package gov.va.med.mhv.usermgmt.service;

import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.common.data.model.UserProfileDeactivationReason;
import gov.va.med.mhv.usermgmt.common.dto.EauthHashDTO;
import gov.va.med.mhv.usermgmt.common.dto.HealthInfoDTO;

public interface UserProfileService {

 	public UserProfileDTO getUserProfileByUserName(String userName);

 	public ResponseUtil getUserProfileResponseByUserName(String userName);

 	public void getProfileByNameBirthDate(String firstName, String lastName, String gender, Date birthDate, ResponseUtil response);
 	
	public void validateHintAnswers(Long userProfileId,String answer1, String answer2, ResponseUtil response);

 	public void getProfileByNameUserNameBirthDate(String firstName, String lastName, String userName, String gender, Date birthDate, ResponseUtil response);

 	//void updateUserProfile(UserProfileDTO userProfile);

 	public void updateUserProfileResponse(UserProfileDTO userProfile, ResponseUtil response);

 	public void registerUser(UserProfileDTO userProfile, ResponseUtil response) throws MHVException;

 	public void savePasswordHistory(UserProfile userProfile, String password, Boolean tempFlag, ResponseUtil response);

 	public void acceptTerms(UserProfile userProfile, Timestamp termsModifiedTime, Timestamp termsAcceptedTime, ResponseUtil response);

 	public void deleteUserProfile(Long userProfileId, ResponseUtil response);

 	public ResponseUtil deleteEauthHashByUserProfileId(Long userProfileId);

 	public ResponseUtil<List<EauthHashDTO>> findEAuthHashByUserProfileId(Long userProfileId);

 	public void changeActivationState(UserProfile userProfile,
        UserProfileDeactivationReason reason, String changedBy, String notes, Date deathDate, ResponseUtil response);

 	public ResponseUtil<UserProfileDTO> getUserProfileByID(Long id);

 	/**
 	 *
 	 * @param profileDto
 	 * @param response
 	 * @param fccxIcn
 	 */
 	public void saveUserProfileMVICorrelationCronJob(UserProfileDTO profileDto, ResponseUtil response, String fccxIcn);

	public void saveUserProfile(UserProfileDTO profileDto, ResponseUtil<UserProfileDTO> response);

	public void saveUserProfile(UserProfileDTO userDto, ResponseUtil<UserProfileDTO> response, boolean doAudit);

	public HealthInfoDTO getHealthInfo(Long userProfileId);

	public ResponseUtil<List<EauthHashDTO>> findUserNameByHash(String ahash);

	String getVapiiFormStatusForUser(Long userProfileId) throws Exception;

	ResponseUtil saveHash(Long userProfileId, String ahash);
	
	ResponseUtil saveHash(String userName, String ahash);
	
	void logEauthEvent(String ahash, String userName, String csid, String map);
	
	public void getProfileForVAAFITraits(String firstName, String lastName, String gender, Date birthDate, ResponseUtil response);

	// T&C Reaccept
	public String hasAcceptedLatestTerms(Long userProfileId) throws MHVException;
	
	public void acceptLatestTerms(Long userProfileId, Boolean accept) throws MHVException;
}
